/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.mana;

import java.util.ArrayList;
import java.util.List;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.choices.ChoiceColor;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

public class AddManaAnyColorAttachedControllerEffect
extends ManaEffect {
    public AddManaAnyColorAttachedControllerEffect() {
        this.staticText = "its controller adds an additional one mana of any color";
    }

    protected AddManaAnyColorAttachedControllerEffect(AddManaAnyColorAttachedControllerEffect effect) {
        super(effect);
    }

    @Override
    public Player getPlayer(Game game, Ability source) {
        Permanent permanentAttachedTo;
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment != null && (permanentAttachedTo = game.getPermanent(enchantment.getAttachedTo())) != null) {
            return game.getPlayer(permanentAttachedTo.getControllerId());
        }
        return null;
    }

    @Override
    public AddManaAnyColorAttachedControllerEffect copy() {
        return new AddManaAnyColorAttachedControllerEffect(this);
    }

    @Override
    public List<Mana> getNetMana(Game game, Ability source) {
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        netMana.add(Mana.AnyMana(1));
        return netMana;
    }

    @Override
    public Mana produceMana(Game game, Ability source) {
        Permanent land;
        Permanent enchantment;
        if (game != null && (enchantment = game.getPermanent(source.getSourceId())) != null && (land = game.getPermanent(enchantment.getAttachedTo())) != null) {
            Player player = game.getPlayer(land.getControllerId());
            ChoiceColor choice = new ChoiceColor();
            if (player != null && player.choose(this.outcome, choice, game)) {
                return choice.getMana(1);
            }
        }
        return new Mana();
    }
}

