/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.mana;

import java.util.ArrayList;
import java.util.List;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.game.Game;
import mage.players.Player;

public class AddManaToManaPoolTargetControllerEffect
extends ManaEffect {
    protected Mana mana;
    protected boolean emptyOnlyOnTurnsEnd;

    public AddManaToManaPoolTargetControllerEffect(Mana mana, String textManaPoolOwner) {
        this(mana, textManaPoolOwner, false);
    }

    public AddManaToManaPoolTargetControllerEffect(Mana mana, String textManaPoolOwner, boolean emptyOnTurnsEnd) {
        this.mana = mana;
        this.emptyOnlyOnTurnsEnd = emptyOnTurnsEnd;
        this.staticText = (textManaPoolOwner.equals("their") ? "that player adds " : "add ") + mana.toString();
    }

    protected AddManaToManaPoolTargetControllerEffect(AddManaToManaPoolTargetControllerEffect effect) {
        super(effect);
        this.mana = effect.mana.copy();
        this.emptyOnlyOnTurnsEnd = effect.emptyOnlyOnTurnsEnd;
    }

    @Override
    public AddManaToManaPoolTargetControllerEffect copy() {
        return new AddManaToManaPoolTargetControllerEffect(this);
    }

    @Override
    public Player getPlayer(Game game, Ability source) {
        return game.getPlayer(this.getTargetPointer().getFirst(game, source));
    }

    @Override
    public List<Mana> getNetMana(Game game, Ability source) {
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        netMana.add(this.mana.copy());
        return netMana;
    }

    @Override
    public Mana produceMana(Game game, Ability source) {
        return this.mana.copy();
    }

    @Override
    protected void addManaToPool(Player player, Mana manaToAdd, Game game, Ability source) {
        player.getManaPool().addMana(manaToAdd, game, source, this.emptyOnlyOnTurnsEnd);
    }
}

