/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.mana;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.TappedForManaEvent;
import mage.players.Player;

public abstract class ManaEffect
extends OneShotEffect {
    protected ManaEffect() {
        super(Outcome.PutManaInPool);
    }

    protected ManaEffect(ManaEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = this.getPlayer(game, source);
        if (player == null) {
            return false;
        }
        if (game.inCheckPlayableState()) {
            if (source.isTriggeredAbility()) {
                player.addAvailableTriggeredMana(this.getNetMana(game, source));
            }
            return true;
        }
        Mana manaToAdd = this.produceMana(game, source);
        if (manaToAdd != null && manaToAdd.count() > 0) {
            this.checkToFirePossibleEvents(manaToAdd, game, source);
            this.addManaToPool(player, manaToAdd, game, source);
        }
        return true;
    }

    protected Player getPlayer(Game game, Ability source) {
        return game.getPlayer(source.getControllerId());
    }

    protected void addManaToPool(Player player, Mana manaToAdd, Game game, Ability source) {
        player.getManaPool().addMana(manaToAdd, game, source);
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        Mana mana = this.produceMana(game, source);
        if (mana != null && mana.count() > 0) {
            netMana.add(mana);
        }
        return netMana;
    }

    public List<Mana> getNetMana(Game game, Mana possibleManaInPool, Ability source) {
        return this.getNetMana(game, source);
    }

    public Set<ManaType> getProducableManaTypes(Game game, Ability source) {
        return ManaType.getManaTypesFromManaList(this.getNetMana(game, source));
    }

    public abstract Mana produceMana(Game var1, Ability var2);

    public void checkToFirePossibleEvents(Mana mana, Game game, Ability source) {
        TappedForManaEvent event;
        if (source.getAbilityType().isManaAbility() && source.hasTapCost() && !game.replaceEvent(event = new TappedForManaEvent(source.getSourceId(), source, source.getControllerId(), mana, game))) {
            game.fireEvent(event);
        }
    }

    @Override
    public ManaEffect setText(String staticText) {
        super.setText(staticText);
        return this;
    }
}

