/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.hint;

import java.awt.Color;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.hint.Hint;
import mage.abilities.hint.HintUtils;
import mage.game.Game;
import mage.util.CardUtil;

public class ConditionHint
implements Hint {
    private final Condition condition;
    private final String trueText;
    private final Color trueColor;
    private final String falseText;
    private final Color falseColor;
    private final boolean useIcons;

    public ConditionHint(Condition condition) {
        this(condition, CardUtil.getTextWithFirstCharUpperCase(condition.toString()));
    }

    public ConditionHint(Condition condition, String textWithIcons) {
        this(condition, textWithIcons, null, textWithIcons, null, true);
    }

    public ConditionHint(Condition condition, String trueText, Color trueColor, String falseText, Color falseColor, boolean useIcons) {
        this.condition = condition;
        this.trueText = CardUtil.getTextWithFirstCharUpperCase(trueText);
        this.trueColor = trueColor;
        this.falseText = CardUtil.getTextWithFirstCharUpperCase(falseText);
        this.falseColor = falseColor;
        this.useIcons = useIcons;
    }

    protected ConditionHint(ConditionHint hint) {
        this.condition = hint.condition;
        this.trueText = hint.trueText;
        this.trueColor = hint.trueColor;
        this.falseText = hint.falseText;
        this.falseColor = hint.falseColor;
        this.useIcons = hint.useIcons;
    }

    @Override
    public String getText(Game game, Ability ability) {
        if (this.condition.apply(game, ability)) {
            String icon = this.useIcons ? "ICON_GOOD" : null;
            return HintUtils.prepareText(this.trueText, this.trueColor, icon);
        }
        String icon = this.useIcons ? "ICON_BAD" : null;
        return HintUtils.prepareText(this.falseText, this.falseColor, icon);
    }

    @Override
    public ConditionHint copy() {
        return new ConditionHint(this);
    }
}

