/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.hint;

import java.awt.Color;
import java.util.HashSet;
import java.util.List;

public class HintUtils {
    public static final boolean ABILITY_HINTS_ENABLE = true;
    public static final boolean RESTRICT_HINTS_ENABLE = true;
    public static final String HINT_ICON_GOOD = "ICON_GOOD";
    public static final String HINT_ICON_BAD = "ICON_BAD";
    public static final String HINT_ICON_RESTRICT = "ICON_RESTRICT";
    public static final String HINT_ICON_REQUIRE = "ICON_REQUIRE";
    public static final String HINT_ICON_DUNGEON_ROOM_CURRENT = "ICON_DUNGEON_ROOM_CURRENT";
    public static final String HINT_ICON_DUNGEON_ROOM_NEXT = "ICON_DUNGEON_ROOM_NEXT";
    public static final String HINT_START_MARK = "<br/><hintstart/>";

    public static String prepareText(String text, Color color) {
        return HintUtils.prepareText(text, color, null);
    }

    public static String prepareText(String text, Color color, String icon) {
        String res;
        if (text != null && color != null) {
            String hex = HintUtils.colorToHtml(color);
            res = String.format("<font color=%s>%s</font>", hex, text);
        } else {
            String string = res = text == null ? "" : text;
        }
        if (res != null && icon != null) {
            res = icon + res;
        }
        return res;
    }

    public static void appendHints(List<String> destList, List<String> newHints) {
        HashSet<String> used = new HashSet<String>();
        for (String s : newHints) {
            if (used.contains(s)) continue;
            destList.add(s);
            used.add(s);
        }
    }

    public static String colorToHtml(Color color) {
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }
}

