/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.keyword.AscendContinuousEffect;
import mage.constants.Zone;
import mage.designations.CitysBlessing;
import mage.designations.DesignationType;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

public class AscendAbility
extends SimpleStaticAbility {
    public static final String ASCEND_RULE = "Ascend <i>(If you control ten or more permanents, you get the city's blessing for the rest of the game.)</i>";

    public AscendAbility() {
        super(Zone.BATTLEFIELD, new AscendContinuousEffect());
    }

    protected AscendAbility(AscendAbility ability) {
        super(ability);
    }

    @Override
    public AscendAbility copy() {
        return new AscendAbility(this);
    }

    public static boolean checkAscend(Game game, Ability source, boolean verbose) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            if (!controller.hasDesignation(DesignationType.CITYS_BLESSING)) {
                if (game.getBattlefield().countAll(StaticFilters.FILTER_PERMANENT, controller.getId(), game) > 9) {
                    controller.addDesignation(new CitysBlessing());
                    game.informPlayers(controller.getLogName() + " gets the city's blessing for the rest of the game.");
                } else if (verbose) {
                    game.informPlayers(controller.getLogName() + " does not get the city's blessing.");
                }
            } else if (verbose) {
                game.informPlayers(controller.getLogName() + " already has the city's blessing.");
            }
            return true;
        }
        return false;
    }

    @Override
    public String getRule() {
        return ASCEND_RULE;
    }
}

