/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.ManaPool;
import mage.players.Player;
import mage.util.ManaUtil;

class AssistEffect
extends OneShotEffect {
    private final ManaCost unpaid;

    AssistEffect(ManaCost unpaid) {
        super(Outcome.Benefit);
        this.unpaid = unpaid;
        this.staticText = "Assist <i>(Another player can help pay the generic mana of this spell's cost.)</i>";
    }

    AssistEffect(AssistEffect effect) {
        super(effect);
        this.unpaid = effect.unpaid;
    }

    @Override
    public AssistEffect copy() {
        return new AssistEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Spell spell = game.getStack().getSpell(source.getSourceId());
        if (controller != null && spell != null && targetPlayer != null) {
            ManaCost cost;
            int amountToPay = 0;
            if (!targetPlayer.isComputer()) {
                amountToPay = targetPlayer.announceX(0, this.unpaid.getMana().getGeneric(), "How much mana to pay as assist for " + controller.getName() + "?", game, source, true);
            }
            if (amountToPay > 0 && (cost = ManaUtil.createManaCost(amountToPay, false)).pay(source, game, source, targetPlayer.getId(), false)) {
                ManaPool manaPool = controller.getManaPool();
                manaPool.addMana(Mana.ColorlessMana(amountToPay), game, source);
                manaPool.unlockManaType(ManaType.COLORLESS);
                game.informPlayers(targetPlayer.getLogName() + " paid {" + amountToPay + "} for " + controller.getLogName());
                game.getState().setValue(source.getSourceId().toString() + game.getState().getZoneChangeCounter(source.getSourceId()) + "_assisted", true);
            }
            return true;
        }
        return false;
    }
}

