/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.ArrayList;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;

class BackupEffect
extends OneShotEffect {
    private final int amount;
    private final List<Ability> abilitiesToAdd = new ArrayList<Ability>();

    public BackupEffect(int amount, List<Ability> abilitiesToAdd) {
        super(Outcome.BoostCreature);
        this.amount = amount;
        this.abilitiesToAdd.addAll(abilitiesToAdd);
    }

    protected BackupEffect(BackupEffect effect) {
        super(effect);
        this.amount = effect.amount;
        this.abilitiesToAdd.addAll(effect.abilitiesToAdd);
    }

    void addAbility(Ability ability) {
        this.abilitiesToAdd.add(ability);
    }

    @Override
    public BackupEffect copy() {
        return new BackupEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        permanent.addCounters(CounterType.P1P1.createInstance(this.amount), source, game);
        if (permanent.getId().equals(source.getSourceId())) {
            return true;
        }
        for (Ability ability : this.abilitiesToAdd) {
            game.addEffect(new GainAbilityTargetEffect(ability).setTargetPointer(new FixedTarget(permanent, game)), source);
        }
        return true;
    }
}

