/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.Set;
import mage.MageIdentifier;
import mage.abilities.SpellAbility;
import mage.abilities.common.DiesSourceTriggeredAbility;
import mage.abilities.common.EntersBattlefieldAbility;
import mage.abilities.condition.common.BlitzedCondition;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.BlitzAddDelayedTriggeredAbilityEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.SpellAbilityType;
import mage.constants.TimingRule;
import mage.game.Game;

public class BlitzAbility
extends SpellAbility {
    public static final String BLITZ_ACTIVATION_VALUE_KEY = "blitzActivation";

    public BlitzAbility(Card card, String manaString) {
        super(new ManaCostsImpl(manaString), card.getName() + " with Blitz");
        this.spellAbilityType = SpellAbilityType.BASE_ALTERNATE;
        EntersBattlefieldAbility ability = new EntersBattlefieldAbility(new GainAbilitySourceEffect(HasteAbility.getInstance(), Duration.Custom, false), BlitzedCondition.instance, "", "");
        ability.addEffect(new GainAbilitySourceEffect(new DiesSourceTriggeredAbility(new DrawCardSourceControllerEffect(1)).setTriggerPhrase("When this creature dies, "), Duration.Custom, false));
        ability.addEffect(new BlitzAddDelayedTriggeredAbilityEffect());
        ability.setRuleVisible(false);
        this.addSubAbility(ability);
        this.setAdditionalCostsRuleVisible(false);
        this.timing = TimingRule.SORCERY;
    }

    private BlitzAbility(BlitzAbility ability) {
        super(ability);
    }

    @Override
    public BlitzAbility copy() {
        return new BlitzAbility(this);
    }

    @Override
    public String getRule() {
        StringBuilder sb = new StringBuilder("Blitz");
        if (this.getCosts().isEmpty()) {
            sb.append(' ');
        } else {
            sb.append("&mdash;");
        }
        sb.append(this.getManaCosts().getText());
        if (!this.getCosts().isEmpty()) {
            sb.append(", ");
            sb.append(this.getCosts().getText());
            sb.append('.');
        }
        sb.append(" <i>(If you cast this spell for its blitz cost, it gains haste ");
        sb.append("and \"When this creature dies, draw a card.\" ");
        sb.append("Sacrifice it at the beginning of the next end step.)</i>");
        return sb.toString();
    }

    @Override
    public boolean activate(Game game, Set<MageIdentifier> allowedIdentifiers, boolean noMana) {
        if (!super.activate(game, allowedIdentifiers, noMana)) {
            return false;
        }
        this.setCostsTag(BLITZ_ACTIVATION_VALUE_KEY, null);
        return true;
    }
}

