/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.Collection;
import mage.abilities.ActivatedAbilityImpl;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.common.BoastCondition;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.InfoEffect;
import mage.abilities.hint.common.BoastHint;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class BoastAbility
extends ActivatedAbilityImpl {
    public BoastAbility(Effect effect, String manaString) {
        this(effect, new ManaCostsImpl(manaString));
    }

    public BoastAbility(Effect effect, Cost cost) {
        super(Zone.BATTLEFIELD, effect, cost);
        this.maxActivationsPerTurn = 1;
        this.condition = BoastCondition.instance;
        this.addHint(BoastHint.instance);
    }

    private BoastAbility(BoastAbility ability) {
        super(ability);
    }

    @Override
    public BoastAbility copy() {
        return new BoastAbility(this);
    }

    @Override
    public boolean hasMoreActivationsThisTurn(Game game) {
        return super.hasMoreActivationsThisTurn(game);
    }

    @Override
    public int getMaxActivationsPerTurn(Game game) {
        if (!game.isActivePlayer(this.getControllerId())) {
            return 1;
        }
        Permanent permanent = game.getPermanent(this.getSourceId());
        if (permanent != null && !permanent.isCreature(game)) {
            return 1;
        }
        return game.getBattlefield().getActivePermanents(StaticFilters.FILTER_CONTROLLED_PERMANENT, this.getControllerId(), this, game).stream().map(p -> p.getAbilities(game)).flatMap(Collection::stream).anyMatch(BoastTwiceAbility.class::isInstance) ? 2 : 1;
    }

    @Override
    public String getRule() {
        return "Boast &mdash; " + super.getRule() + " <i>(Activate only if this creature attacked this turn and only once each turn.)</i>";
    }

    public static BoastTwiceAbility makeBoastTwiceAbility() {
        return new BoastTwiceAbility();
    }

    private static final class BoastTwiceAbility
    extends SimpleStaticAbility {
        private BoastTwiceAbility() {
            super(new InfoEffect("Creatures you control can boast twice during each of your turns rather than once."));
        }

        private BoastTwiceAbility(BoastTwiceAbility ability) {
            super(ability);
        }

        @Override
        public BoastTwiceAbility copy() {
            return new BoastTwiceAbility(this);
        }
    }
}

