/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.abilities.ActivatedAbility;
import mage.abilities.SpellAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.Costs;
import mage.abilities.keyword.CastFromGraveyardReplacementEffect;
import mage.cards.Card;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.SplitCard;
import mage.constants.SpellAbilityCastMode;
import mage.constants.SpellAbilityType;
import mage.constants.TimingRule;
import mage.constants.Zone;
import mage.game.Game;
import mage.target.targetpointer.FixedTarget;

public abstract class CastFromGraveyardAbility
extends SpellAbility {
    protected String abilityName;
    private SpellAbility spellAbilityToResolve;

    protected CastFromGraveyardAbility(Card card, Cost cost, SpellAbilityCastMode spellAbilityCastMode) {
        super(null, "", Zone.GRAVEYARD, SpellAbilityType.BASE_ALTERNATE, spellAbilityCastMode);
        this.setAdditionalCostsRuleVisible(false);
        this.name = (Object)((Object)spellAbilityCastMode) + " " + cost.getText();
        this.addCost(cost);
        this.timing = card.isSorcery() ? TimingRule.SORCERY : TimingRule.INSTANT;
    }

    protected CastFromGraveyardAbility(CastFromGraveyardAbility ability) {
        super(ability);
        this.abilityName = ability.abilityName;
        this.spellAbilityToResolve = ability.spellAbilityToResolve;
    }

    @Override
    public ActivatedAbility.ActivationStatus canActivate(UUID playerId, Game game) {
        if (!super.canActivate(playerId, game).canActivate()) {
            return ActivatedAbility.ActivationStatus.getFalse();
        }
        Card card = game.getCard(this.getSourceId());
        if (card == null) {
            return ActivatedAbility.ActivationStatus.getFalse();
        }
        if (game.getState().getZone(card.getId()) != Zone.GRAVEYARD) {
            return ActivatedAbility.ActivationStatus.getFalse();
        }
        if (card.getManaCost().isEmpty()) {
            return ActivatedAbility.ActivationStatus.getFalse();
        }
        if (card instanceof SplitCard) {
            if (((SplitCard)card).getLeftHalfCard().getName().equals(this.abilityName)) {
                return ((SplitCard)card).getLeftHalfCard().getSpellAbility().canActivate(playerId, game);
            }
            if (((SplitCard)card).getRightHalfCard().getName().equals(this.abilityName)) {
                return ((SplitCard)card).getRightHalfCard().getSpellAbility().canActivate(playerId, game);
            }
        } else if (card instanceof ModalDoubleFacedCard) {
            if (((ModalDoubleFacedCard)card).getLeftHalfCard().getName().equals(this.abilityName)) {
                return ((ModalDoubleFacedCard)card).getLeftHalfCard().getSpellAbility().canActivate(playerId, game);
            }
            if (((ModalDoubleFacedCard)card).getRightHalfCard().getName().equals(this.abilityName)) {
                return ((ModalDoubleFacedCard)card).getRightHalfCard().getSpellAbility().canActivate(playerId, game);
            }
        }
        return card.getSpellAbility().canActivate(playerId, game);
    }

    @Override
    public SpellAbility getSpellAbilityToResolve(Game game) {
        Card card = game.getCard(this.getSourceId());
        if (card == null || this.spellAbilityToResolve != null) {
            return this.spellAbilityToResolve;
        }
        SpellAbility spellAbilityCopy = card instanceof SplitCard ? (((SplitCard)card).getLeftHalfCard().getName().equals(this.abilityName) ? ((SplitCard)card).getLeftHalfCard().getSpellAbility().copy() : (((SplitCard)card).getRightHalfCard().getName().equals(this.abilityName) ? ((SplitCard)card).getRightHalfCard().getSpellAbility().copy() : null)) : (card instanceof ModalDoubleFacedCard ? (((ModalDoubleFacedCard)card).getLeftHalfCard().getName().equals(this.abilityName) ? ((ModalDoubleFacedCard)card).getLeftHalfCard().getSpellAbility().copy() : (((ModalDoubleFacedCard)card).getRightHalfCard().getName().equals(this.abilityName) ? ((ModalDoubleFacedCard)card).getRightHalfCard().getSpellAbility().copy() : null)) : card.getSpellAbility().copy());
        if (spellAbilityCopy == null) {
            return null;
        }
        spellAbilityCopy.setId(this.getId());
        spellAbilityCopy.clearManaCosts();
        spellAbilityCopy.clearManaCostsToPay();
        spellAbilityCopy.addCost(this.getCosts().copy());
        spellAbilityCopy.addCost(this.getManaCosts().copy());
        spellAbilityCopy.setSpellAbilityCastMode(this.getSpellAbilityCastMode());
        spellAbilityCopy.setCostAdjuster(this.getCostAdjuster());
        this.spellAbilityToResolve = spellAbilityCopy;
        CastFromGraveyardReplacementEffect effect = new CastFromGraveyardReplacementEffect();
        effect.setTargetPointer(new FixedTarget(this.getSourceId(), game.getState().getZoneChangeCounter(this.getSourceId())));
        game.addEffect(effect, this);
        return this.spellAbilityToResolve;
    }

    @Override
    public Costs<Cost> getCosts() {
        if (this.spellAbilityToResolve == null) {
            return super.getCosts();
        }
        return this.spellAbilityToResolve.getCosts();
    }

    @Override
    public String getRule(boolean all) {
        return this.getRule();
    }

    public CastFromGraveyardAbility setAbilityName(String abilityName) {
        this.abilityName = abilityName;
        return this;
    }
}

