/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.util.CardUtil;

class CastFromGraveyardReplacementEffect
extends ReplacementEffectImpl {
    public CastFromGraveyardReplacementEffect() {
        super(Duration.OneUse, Outcome.Exile);
    }

    protected CastFromGraveyardReplacementEffect(CastFromGraveyardReplacementEffect effect) {
        super(effect);
    }

    @Override
    public CastFromGraveyardReplacementEffect copy() {
        return new CastFromGraveyardReplacementEffect(this);
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = game.getCard(event.getTargetId());
        if (card == null) {
            return false;
        }
        this.discard();
        return controller.moveCards(card, Zone.EXILED, source, game, false, false, false, event.getAppliedEffects());
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        UUID cardId = CardUtil.getMainCardId(game, source.getSourceId());
        if (!cardId.equals(event.getTargetId()) || ((ZoneChangeEvent)event).getFromZone() != Zone.STACK || ((ZoneChangeEvent)event).getToZone() == Zone.EXILED) {
            return false;
        }
        int zcc = game.getState().getZoneChangeCounter(cardId);
        return ((FixedTarget)this.getTargetPointer()).getZoneChangeCounter() + 1 == zcc;
    }
}

