/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.Arrays;
import java.util.List;
import mage.abilities.StaticAbility;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.common.LeavesBattlefieldTriggeredAbility;
import mage.abilities.effects.common.ReturnFromExileForSourceEffect;
import mage.abilities.effects.common.SacrificeSourceUnlessPaysEffect;
import mage.abilities.keyword.ChampionExileCost;
import mage.cards.Card;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.util.CardUtil;

public class ChampionAbility
extends StaticAbility {
    protected final String objectDescription;
    protected final String etbObjectDescription;

    public ChampionAbility(Card card, SubType ... subtypes) {
        super(Zone.BATTLEFIELD, null);
        FilterControlledPermanent filter;
        this.etbObjectDescription = EntersBattlefieldTriggeredAbility.getThisObjectDescription(card);
        List<SubType> subTypes = Arrays.asList(subtypes);
        switch (subTypes.size()) {
            case 0: {
                this.objectDescription = "creature";
                filter = StaticFilters.FILTER_CONTROLLED_ANOTHER_CREATURE;
                break;
            }
            case 1: {
                SubType subType = subTypes.get(0);
                this.objectDescription = subType.getDescription();
                filter = new FilterControlledPermanent(subType, "another " + (Object)((Object)subType));
                filter.add(AnotherPredicate.instance);
                break;
            }
            case 2: {
                SubType subType1 = subTypes.get(0);
                SubType subType2 = subTypes.get(1);
                this.objectDescription = subType1.getDescription() + " or " + subType2.getDescription();
                filter = new FilterControlledPermanent();
                filter.add(Predicates.or(subType1.getPredicate(), subType2.getPredicate()));
                filter.add(AnotherPredicate.instance);
                break;
            }
            default: {
                throw new UnsupportedOperationException("can't have more than two subtypes currently");
            }
        }
        EntersBattlefieldTriggeredAbility ability1 = new EntersBattlefieldTriggeredAbility(new SacrificeSourceUnlessPaysEffect(new ChampionExileCost(filter)), false);
        ability1.setRuleVisible(false);
        this.addSubAbility(ability1);
        LeavesBattlefieldTriggeredAbility ability2 = new LeavesBattlefieldTriggeredAbility(new ReturnFromExileForSourceEffect(Zone.BATTLEFIELD), false);
        ability2.setRuleVisible(false);
        this.addSubAbility(ability2);
    }

    protected ChampionAbility(ChampionAbility ability) {
        super(ability);
        this.objectDescription = ability.objectDescription;
        this.etbObjectDescription = ability.etbObjectDescription;
    }

    @Override
    public ChampionAbility copy() {
        return new ChampionAbility(this);
    }

    @Override
    public String getRule() {
        return "Champion " + CardUtil.addArticle(this.objectDescription) + " <i>(When " + this.etbObjectDescription + " enters, sacrifice it unless you exile another " + this.objectDescription + " you control. When this leaves the battlefield, that card returns to the battlefield.)</i>";
    }
}

