/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.stream.Collectors;
import mage.abilities.ActivatedAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.ExileSourceFromGraveCost;
import mage.abilities.keyword.EternalizeEffect;
import mage.cards.Card;
import mage.constants.SubType;
import mage.constants.TimingRule;
import mage.constants.Zone;

public class EternalizeAbility
extends ActivatedAbilityImpl {
    private final String rule;

    public EternalizeAbility(Cost cost, Card card) {
        this(cost, card, EternalizeAbility.setRule(cost, card));
    }

    public EternalizeAbility(Cost cost, Card card, String rule) {
        super(Zone.GRAVEYARD, new EternalizeEffect(), cost);
        this.addCost(new ExileSourceFromGraveCost());
        this.rule = rule;
        this.timing = TimingRule.SORCERY;
    }

    protected EternalizeAbility(EternalizeAbility ability) {
        super(ability);
        this.rule = ability.rule;
    }

    @Override
    public EternalizeAbility copy() {
        return new EternalizeAbility(this);
    }

    @Override
    public String getRule() {
        return this.rule;
    }

    private static String setRule(Cost cost, Card card) {
        return "Eternalize " + cost.getText() + " <i>(" + cost.getText() + ", Exile this card from your graveyard: Create a token that's a copy of it, except it's a 4/4 black Zombie " + card.getSubtype().stream().map(SubType::getDescription).map(s -> s + ' ').collect(Collectors.joining()) + "with no mana cost. Eternalize only as a sorcery.)</i>";
    }
}

