/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.common.BecomesExertSourceTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.keyword.ExertReplacementEffect;
import mage.abilities.keyword.ExertedThisTurnWatcher;
import mage.constants.Zone;

public class ExertAbility
extends SimpleStaticAbility {
    private String ruleText;

    public ExertAbility(BecomesExertSourceTriggeredAbility ability) {
        this(ability, false);
    }

    public ExertAbility(BecomesExertSourceTriggeredAbility ability, boolean exertOnlyOncePerTurn) {
        super(Zone.BATTLEFIELD, new ExertReplacementEffect(exertOnlyOncePerTurn));
        this.ruleText = (exertOnlyOncePerTurn ? "If {this} hasn't been exerted this turn, you may exert it" : "You may exert {this}") + " as it attacks.";
        if (ability != null) {
            this.addSubAbility(ability);
            this.ruleText = this.ruleText + " When you do,";
            ability.getEffects().forEach(effect -> {
                if (!effect.getConcatPrefix().isEmpty()) {
                    this.ruleText = this.ruleText + " " + effect.getConcatPrefix();
                }
                this.ruleText = this.ruleText + " " + effect.getText(ability.getModes().getMode()).replaceFirst("^\\{this\\}", "it");
            });
            this.ruleText = this.ruleText + ".";
            ability.setRuleVisible(false);
        }
        this.ruleText = this.ruleText + " <i>(An exerted creature won't untap during your next untap step.)</i>";
        if (exertOnlyOncePerTurn) {
            this.getWatchers().add(new ExertedThisTurnWatcher());
        }
    }

    protected ExertAbility(ExertAbility ability) {
        super(ability);
        this.ruleText = ability.ruleText;
    }

    @Override
    public ExertAbility copy() {
        return new ExertAbility(this);
    }

    @Override
    public String getRule() {
        return this.ruleText;
    }
}

