/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.ActivatedAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.effects.Effect;
import mage.constants.AsThoughEffectType;
import mage.constants.Zone;
import mage.game.Game;

public class ExhaustAbility
extends ActivatedAbilityImpl {
    private final boolean withReminderText;

    public ExhaustAbility(Effect effect, Cost cost) {
        this(effect, cost, true);
    }

    public ExhaustAbility(Effect effect, Cost cost, boolean withReminderText) {
        super(Zone.BATTLEFIELD, effect, cost);
        this.withReminderText = withReminderText;
    }

    private ExhaustAbility(ExhaustAbility ability) {
        super(ability);
        this.maxActivationsPerGame = 1;
        this.withReminderText = ability.withReminderText;
    }

    @Override
    public ExhaustAbility copy() {
        return new ExhaustAbility(this);
    }

    @Override
    public boolean hasMoreActivationsThisTurn(Game game) {
        ActivatedAbilityImpl.ActivationInfo info = this.getActivationInfo(game);
        if (info != null && info.totalActivations >= this.maxActivationsPerGame) {
            boolean canActivate;
            boolean bl = canActivate = !game.getContinuousEffects().asThough(this.sourceId, AsThoughEffectType.ALLOW_EXHAUST_PER_TURN, this, this.controllerId, game).isEmpty();
            if (canActivate) {
                return true;
            }
        }
        return super.hasMoreActivationsThisTurn(game);
    }

    @Override
    public String getRule() {
        return "Exhaust &mdash; " + super.getRule() + (this.withReminderText ? " <i>(Activate each exhaust ability only once.)</i>" : "");
    }
}

