/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.common.EntersBattlefieldAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.abilities.keyword.FadingEffect;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.cards.Card;
import mage.constants.CardType;
import mage.counters.CounterType;
import mage.util.CardUtil;

public class FadingAbility
extends EntersBattlefieldAbility {
    private String ruleText;

    public FadingAbility(int fadeCounter, Card card) {
        this(fadeCounter, card, false);
    }

    public FadingAbility(int fadeCounter, Card card, boolean shortRuleText) {
        super((Effect)new AddCountersSourceEffect(CounterType.FADE.createInstance(fadeCounter)), "with");
        BeginningOfUpkeepTriggeredAbility ability = new BeginningOfUpkeepTriggeredAbility(new FadingEffect());
        ability.setRuleVisible(false);
        this.addSubAbility(ability);
        String cardTypeName = card.getCardType().contains((Object)CardType.CREATURE) ? "creature" : (card.getCardType().contains((Object)CardType.ARTIFACT) ? "artifact" : (card.getCardType().contains((Object)CardType.ENCHANTMENT) ? "enchantment" : "permanent"));
        this.ruleText = "Fading " + fadeCounter + (shortRuleText ? "" : " <i>(This " + cardTypeName + " enters the battlefield with " + CardUtil.numberToText(fadeCounter) + " fade counters on it. At the beginning of your upkeep, remove a fade counter from it. If you can't, sacrifice it.)</i>");
    }

    protected FadingAbility(FadingAbility ability) {
        super(ability);
        this.ruleText = ability.ruleText;
    }

    @Override
    public FadingAbility copy() {
        return new FadingAbility(this);
    }

    @Override
    public String getRule() {
        return this.ruleText;
    }
}

