/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class FirebendingAbilityEffect
extends OneShotEffect {
    private final DynamicValue amount;

    FirebendingAbilityEffect(DynamicValue amount) {
        super(Outcome.Benefit);
        this.amount = amount;
    }

    private FirebendingAbilityEffect(FirebendingAbilityEffect effect) {
        super(effect);
        this.amount = effect.amount;
    }

    @Override
    public FirebendingAbilityEffect copy() {
        return new FirebendingAbilityEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int amount = Math.max(this.amount.calculate(game, source, this), 0);
        if (amount > 0) {
            player.getManaPool().addMana(Mana.RedMana(amount), game, source, Duration.EndOfCombat);
        }
        game.fireEvent(GameEvent.getEvent(GameEvent.EventType.FIREBENDED, source.getSourceId(), source, source.getControllerId(), amount));
        return true;
    }
}

