/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.SpecialAction;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.keyword.ForetellAddAbilityEffect;
import mage.abilities.keyword.ForetellAddCostEffect;
import mage.abilities.keyword.ForetellCostAbility;
import mage.abilities.keyword.ForetellExileEffect;
import mage.abilities.keyword.ForetellLookAtCardEffect;
import mage.cards.Card;
import mage.cards.CardWithSpellOption;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.ModalDoubleFacedCardHalf;
import mage.cards.SplitCard;
import mage.constants.AsThoughEffectType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.util.CardUtil;
import mage.watchers.common.ForetoldWatcher;

public class ForetellAbility
extends SpecialAction {
    private final String foretellCost;
    private final String foretellSplitCost;
    private final Card card;

    public ForetellAbility(Card card, String foretellCost) {
        this(card, foretellCost, null);
    }

    public ForetellAbility(Card card, String foretellCost, String foretellSplitCost) {
        super(Zone.HAND);
        this.foretellCost = foretellCost;
        this.foretellSplitCost = foretellSplitCost;
        this.card = card;
        this.usesStack = Boolean.FALSE;
        this.addCost(new GenericManaCost(2));
        this.addEffect(new ForetellExileEffect(card, foretellCost, foretellSplitCost));
        SimpleStaticAbility ability = new SimpleStaticAbility(Zone.ALL, new ForetellLookAtCardEffect());
        ability.setControllerId(this.controllerId);
        this.addSubAbility(ability);
        this.setRuleVisible(true);
        this.addWatcher(new ForetoldWatcher());
    }

    private ForetellAbility(ForetellAbility ability) {
        super(ability);
        this.foretellCost = ability.foretellCost;
        this.foretellSplitCost = ability.foretellSplitCost;
        this.card = ability.card;
    }

    @Override
    public ForetellAbility copy() {
        return new ForetellAbility(this);
    }

    @Override
    public ActivatedAbility.ActivationStatus canActivate(UUID playerId, Game game) {
        if (game.getState().getContinuousEffects().getApplicableAsThoughEffects(AsThoughEffectType.ALLOW_FORETELL_ANYTIME, game).isEmpty() && !game.isActivePlayer(this.getControllerId())) {
            return ActivatedAbility.ActivationStatus.getFalse();
        }
        return super.canActivate(playerId, game);
    }

    @Override
    public String getRule() {
        return "Foretell " + this.foretellCost + " <i>(During your turn, you may pay {2} and exile this card from your hand face down. Cast it on a later turn for its foretell cost.)</i>";
    }

    @Override
    public String getGameLogMessage(Game game) {
        return " foretells a card from hand";
    }

    public static boolean isCardInForetell(Card card, Game game) {
        return card.getAbilities(game).containsClass(ForetellCostAbility.class);
    }

    public static ContinuousEffect makeAddForetellEffect() {
        return new ForetellAddAbilityEffect();
    }

    public static boolean doExileBecomesForetold(Card card, Game game, Ability source, int amountToReduceCost) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ForetellAbility foretellAbility = null;
        if (card instanceof SplitCard) {
            String leftHalfCost = CardUtil.reduceCost(((SplitCard)card).getLeftHalfCard().getManaCost(), amountToReduceCost).getText();
            String rightHalfCost = CardUtil.reduceCost(((SplitCard)card).getRightHalfCard().getManaCost(), amountToReduceCost).getText();
            game.getState().setValue(card.getMainCard().getId().toString() + "Foretell Cost", leftHalfCost);
            game.getState().setValue(card.getMainCard().getId().toString() + "Foretell Split Cost", rightHalfCost);
            foretellAbility = new ForetellAbility(card, leftHalfCost, rightHalfCost);
        } else if (card instanceof ModalDoubleFacedCard) {
            ModalDoubleFacedCardHalf leftHalfCard = ((ModalDoubleFacedCard)card).getLeftHalfCard();
            if (!leftHalfCard.isLand(game)) {
                String leftHalfCost = CardUtil.reduceCost(leftHalfCard.getManaCost(), amountToReduceCost).getText();
                game.getState().setValue(card.getMainCard().getId().toString() + "Foretell Cost", leftHalfCost);
                ModalDoubleFacedCardHalf rightHalfCard = ((ModalDoubleFacedCard)card).getRightHalfCard();
                if (rightHalfCard.isLand(game)) {
                    foretellAbility = new ForetellAbility(card, leftHalfCost);
                } else {
                    String rightHalfCost = CardUtil.reduceCost(rightHalfCard.getManaCost(), amountToReduceCost).getText();
                    game.getState().setValue(card.getMainCard().getId().toString() + "Foretell Split Cost", rightHalfCost);
                    foretellAbility = new ForetellAbility(card, leftHalfCost, rightHalfCost);
                }
            }
        } else if (card instanceof CardWithSpellOption) {
            String creatureCost = CardUtil.reduceCost(card.getMainCard().getManaCost(), amountToReduceCost).getText();
            String spellCost = CardUtil.reduceCost(((CardWithSpellOption)card).getSpellCard().getManaCost(), amountToReduceCost).getText();
            game.getState().setValue(card.getMainCard().getId().toString() + "Foretell Cost", creatureCost);
            game.getState().setValue(card.getMainCard().getId().toString() + "Foretell Split Cost", spellCost);
            foretellAbility = new ForetellAbility(card, creatureCost, spellCost);
        } else if (!card.isLand(game)) {
            String costText = CardUtil.reduceCost(card.getManaCost(), amountToReduceCost).getText();
            game.getState().setValue(card.getId().toString() + "Foretell Cost", costText);
            foretellAbility = new ForetellAbility(card, costText);
        }
        UUID exileId = CardUtil.getExileZoneId(card.getMainCard().getId().toString() + "foretellAbility", game);
        controller.moveCardsToExile(card, source, game, false, exileId, " Foretell Turn Number: " + game.getTurnNum());
        card.setFaceDown(true, game);
        if (foretellAbility != null) {
            Ability copiedSource = source.copy();
            copiedSource.newId();
            copiedSource.setSourceId(card.getId());
            game.getState().setValue(card.getMainCard().getId().toString() + "Foretell Turn Number", game.getTurnNum());
            foretellAbility.setSourceId(card.getId());
            foretellAbility.setControllerId(card.getOwnerId());
            game.getState().addOtherAbility(card, foretellAbility);
            foretellAbility.activate(game, true);
            game.addEffect(new ForetellAddCostEffect(new MageObjectReference(card, game)), copiedSource);
            game.fireEvent(new GameEvent(GameEvent.EventType.CARD_FORETOLD, card.getId(), copiedSource, copiedSource.getControllerId(), 0, false));
        }
        return true;
    }
}

