/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.ActivatedAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.common.AttachEffect;
import mage.constants.Outcome;
import mage.constants.TimingRule;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.target.Target;
import mage.target.TargetPermanent;

public class FortifyAbility
extends ActivatedAbilityImpl {
    public FortifyAbility(int cost) {
        this(Outcome.AddAbility, new GenericManaCost(cost));
    }

    public FortifyAbility(Outcome outcome, Cost cost) {
        this(outcome, cost, new TargetPermanent(StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND));
    }

    public FortifyAbility(Outcome outcome, Cost cost, Target target) {
        super(Zone.BATTLEFIELD, new AttachEffect(outcome, "Fortify"), cost);
        this.addTarget(target);
        this.timing = TimingRule.SORCERY;
    }

    protected FortifyAbility(FortifyAbility ability) {
        super(ability);
    }

    @Override
    public FortifyAbility copy() {
        return new FortifyAbility(this);
    }

    @Override
    public String getRule() {
        return "Fortify " + this.getCosts().getText() + this.getManaCosts().getText() + " (" + this.getManaCosts().getText() + ": <i>Attach to target land you control. Fortify only as a sorcery.)</i>";
    }
}

