/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.StaticAbility;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.condition.common.GiftWasPromisedCondition;
import mage.abilities.costs.Cost;
import mage.abilities.costs.Costs;
import mage.abilities.costs.OptionalAdditionalCost;
import mage.abilities.costs.OptionalAdditionalCostImpl;
import mage.abilities.costs.OptionalAdditionalSourceCosts;
import mage.abilities.keyword.PromiseGiftCost;
import mage.abilities.keyword.PromiseGiftEffect;
import mage.cards.Card;
import mage.constants.GiftType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

public class GiftAbility
extends StaticAbility
implements OptionalAdditionalSourceCosts {
    private static final String keywordText = "Gift";
    private static final String reminderText = "You may promise an opponent a gift as you cast this spell. If you do, ";
    private final String rule;
    public static final String GIFT_ACTIVATION_VALUE_KEY = "giftPromisedActivation";
    protected OptionalAdditionalCost additionalCost;
    private final GiftType giftType;

    private static String makeReminderText(GiftType giftType, boolean isPermanent) {
        return reminderText + (isPermanent ? "when it enters, " : "") + "they " + giftType.getDescription() + (isPermanent ? "." : " before its other effects.");
    }

    public GiftAbility(Card card, GiftType giftType) {
        super(Zone.STACK, null);
        this.additionalCost = new OptionalAdditionalCostImpl("Gift " + giftType.getName(), GiftAbility.makeReminderText(giftType, card.isPermanent()), new PromiseGiftCost(giftType));
        this.additionalCost.setRepeatable(false);
        this.giftType = giftType;
        this.rule = this.additionalCost.getName() + ' ' + this.additionalCost.getReminderText();
        this.setRuleAtTheTop(true);
        if (card.isPermanent()) {
            this.addSubAbility(new EntersBattlefieldTriggeredAbility(new PromiseGiftEffect(giftType)).setTriggerPhrase("When this permanent enters, ").withInterveningIf(GiftWasPromisedCondition.TRUE).setRuleVisible(false));
        } else {
            card.getSpellAbility().addEffect(new PromiseGiftEffect(giftType));
        }
    }

    private GiftAbility(GiftAbility ability) {
        super(ability);
        this.rule = ability.rule;
        this.additionalCost = ability.additionalCost.copy();
        this.giftType = ability.giftType;
    }

    @Override
    public GiftAbility copy() {
        return new GiftAbility(this);
    }

    @Override
    public void addOptionalAdditionalCosts(Ability ability, Game game) {
        if (!(ability instanceof SpellAbility)) {
            return;
        }
        Player player = game.getPlayer(ability.getControllerId());
        if (player == null) {
            return;
        }
        this.additionalCost.reset();
        if (!this.additionalCost.canPay(ability, this, ability.getControllerId(), game) || !player.chooseUse(Outcome.Benefit, "Promise an opponent " + this.giftType.getName() + '?', ability, game)) {
            return;
        }
        this.additionalCost.activate();
        for (Cost cost : (Costs)((Object)this.additionalCost)) {
            ability.getCosts().add(cost.copy());
        }
        ability.setCostsTag(GIFT_ACTIVATION_VALUE_KEY, null);
    }

    @Override
    public String getCastMessageSuffix() {
        return this.additionalCost.getCastSuffixMessage(0);
    }

    @Override
    public String getRule() {
        return this.rule;
    }
}

