/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.StaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.EntersBattlefieldEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.util.CardUtil;

class GraftStaticAbility
extends StaticAbility {
    private String ruleText;

    public GraftStaticAbility(int amount) {
        super(Zone.ALL, new EntersBattlefieldEffect((Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance(amount))));
        this.ruleText = "This enters the battlefield with " + CardUtil.getOneOneCountersText(amount) + " on it.";
        this.setRuleVisible(false);
    }

    protected GraftStaticAbility(GraftStaticAbility ability) {
        super(ability);
        this.ruleText = ability.ruleText;
    }

    @Override
    public GraftStaticAbility copy() {
        return new GraftStaticAbility(this);
    }

    @Override
    public String getRule() {
        return this.ruleText;
    }
}

