/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.watchers.common.GravestormWatcher;

class GravestormEffect
extends OneShotEffect {
    GravestormEffect() {
        super(Outcome.Copy);
    }

    GravestormEffect(GravestormEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        GravestormWatcher watcher;
        MageObjectReference spellRef = (MageObjectReference)this.getValue("GravestormSpellRef");
        if (spellRef != null && (watcher = game.getState().getWatcher(GravestormWatcher.class)) != null) {
            Spell spell;
            int gravestormCount = watcher.getGravestormCount();
            if (gravestormCount > 0 && (spell = (Spell)this.getValue("GravestormSpell")) != null) {
                if (!game.isSimulation()) {
                    game.informPlayers("Gravestorm: " + spell.getName() + " will be copied " + gravestormCount + " time" + (gravestormCount > 1 ? "s" : ""));
                }
                spell.createCopyOnStack(game, source, source.getControllerId(), true, gravestormCount);
            }
            return true;
        }
        return false;
    }

    @Override
    public GravestormEffect copy() {
        return new GravestormEffect(this);
    }
}

