/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.CostAdjuster;
import mage.abilities.costs.common.TapTargetCost;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;
import mage.target.common.TargetControlledPermanent;
import mage.util.CardUtil;

enum HarmonizeAbilityAdjuster implements CostAdjuster
{
    instance;


    @Override
    public void reduceCost(Ability ability, Game game) {
        if (game.inCheckPlayableState()) {
            int amount = game.getBattlefield().getActivePermanents(StaticFilters.FILTER_CONTROLLED_UNTAPPED_CREATURE, ability.getControllerId(), ability, game).stream().map(MageObject::getPower).mapToInt(MageInt::getValue).max().orElse(0);
            CardUtil.reduceCost(ability, amount);
            return;
        }
        Player player = game.getPlayer(ability.getControllerId());
        if (player == null || !game.getBattlefield().contains(StaticFilters.FILTER_CONTROLLED_UNTAPPED_CREATURE, ability, game, 1) || !player.chooseUse(Outcome.Tap, "Tap a creature to reduce the cost of this spell?", ability, game)) {
            return;
        }
        TargetPermanent target = new TargetPermanent(StaticFilters.FILTER_CONTROLLED_UNTAPPED_CREATURE);
        target.withNotTarget(true);
        target.withChooseHint("to pay for harmonize");
        player.choose(Outcome.Tap, target, ability, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return;
        }
        CardUtil.reduceCost(ability, permanent.getPower().getValue());
        FilterControlledPermanent filter = new FilterControlledPermanent("creature chosen to tap for harmonize");
        filter.add(new PermanentIdPredicate(permanent.getId()));
        ability.addCost(new TapTargetCost(new TargetControlledPermanent(filter)));
    }
}

