/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.HideawayLookAtFaceDownCardEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.targetpointer.FixedTarget;
import mage.util.CardUtil;

class HideawayExileEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("card to exile face down");
    private final int amount;

    HideawayExileEffect(int amount) {
        super(Outcome.Benefit);
        this.amount = amount;
    }

    private HideawayExileEffect(HideawayExileEffect effect) {
        super(effect);
        this.amount = effect.amount;
    }

    @Override
    public HideawayExileEffect copy() {
        return new HideawayExileEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, this.amount));
        if (cards.isEmpty()) {
            return true;
        }
        TargetCard target = new TargetCard(Zone.LIBRARY, filter);
        target.withNotTarget(true);
        controller.choose(Outcome.Detriment, cards, target, source, game);
        Card card = cards.get(target.getFirstTarget(), game);
        if (card != null) {
            controller.moveCardsToExile(card, source, game, false, CardUtil.getExileZoneId(game, source), "Hideaway (" + CardUtil.getSourceName(game, source) + ')');
            game.addEffect(new HideawayLookAtFaceDownCardEffect().setTargetPointer(new FixedTarget(card, game)), source);
            card.setFaceDown(true, game);
        }
        cards.retainZone(Zone.LIBRARY, game);
        controller.putCardsOnBottomOfLibrary(cards, game, source, false);
        return true;
    }
}

