/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.ImpendingAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ImpendingAbilityRemoveEffect
extends ContinuousEffectImpl {
    ImpendingAbilityRemoveEffect() {
        super(Duration.Custom, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.LoseAbility);
    }

    private ImpendingAbilityRemoveEffect(ImpendingAbilityRemoveEffect effect) {
        super(effect);
    }

    @Override
    public ImpendingAbilityRemoveEffect copy() {
        return new ImpendingAbilityRemoveEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            this.discard();
            return false;
        }
        permanent.removeAbilities(permanent.getAbilities(game).stream().filter(ImpendingAbility.class::isInstance).collect(Collectors.toList()), source.getSourceId(), game);
        return true;
    }
}

