/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.mana.ActivationManaAbilityStep;
import mage.abilities.costs.mana.AlternateManaPaymentAbility;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.hint.ValueHint;
import mage.abilities.keyword.ImproviseSpecialAction;
import mage.abilities.mana.ManaOptions;
import mage.constants.AbilityType;
import mage.constants.Zone;
import mage.filter.common.FilterControlledArtifactPermanent;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetControlledPermanent;

public class ImproviseAbility
extends SimpleStaticAbility
implements AlternateManaPaymentAbility {
    private static final FilterControlledArtifactPermanent filterUntapped = new FilterControlledArtifactPermanent("untapped artifact you control");
    private static final DynamicValue untappedCount;

    public ImproviseAbility() {
        super(Zone.ALL, null);
        this.setRuleAtTheTop(true);
        this.addHint(new ValueHint("Untapped artifacts you control", untappedCount));
    }

    protected ImproviseAbility(ImproviseAbility ability) {
        super(ability);
    }

    @Override
    public ImproviseAbility copy() {
        return new ImproviseAbility(this);
    }

    @Override
    public String getRule() {
        return "improvise <i>(Your artifacts can help cast this spell. Each artifact you tap after you're done activating mana abilities pays for {1}.)</i>";
    }

    @Override
    public ActivationManaAbilityStep useOnActivationManaAbilityStep() {
        return ActivationManaAbilityStep.AFTER;
    }

    @Override
    public void addSpecialAction(Ability source, Game game, ManaCost unpaid) {
        Player controller = game.getPlayer(source.getControllerId());
        int canPayCount = untappedCount.calculate(game, source, null);
        if (controller != null && canPayCount > 0 && source.getAbilityType() == AbilityType.SPELL && unpaid.getMana().getGeneric() > 0) {
            ImproviseSpecialAction specialAction = new ImproviseSpecialAction(unpaid, (AlternateManaPaymentAbility)this);
            specialAction.setControllerId(source.getControllerId());
            specialAction.setSourceId(source.getSourceId());
            TargetControlledPermanent target = new TargetControlledPermanent(1, unpaid.getMana().getGeneric(), filterUntapped, true);
            target.withTargetName("artifact to tap as Improvise's pay");
            specialAction.addTarget(target);
            if (specialAction.canActivate(source.getControllerId(), game).canActivate()) {
                game.getState().getSpecialActions().add(specialAction);
            }
        }
    }

    @Override
    public ManaOptions getManaOptions(Ability source, Game game, ManaCost unpaid) {
        ManaOptions options = new ManaOptions();
        Player controller = game.getPlayer(source.getControllerId());
        int canPayCount = untappedCount.calculate(game, source, null);
        if (controller != null && canPayCount > 0) {
            options.addMana(Mana.GenericMana(Math.min(unpaid.getMana().getGeneric(), canPayCount)));
        }
        return options;
    }

    static {
        filterUntapped.add(TappedPredicate.UNTAPPED);
        untappedCount = new PermanentsOnBattlefieldCount(filterUntapped);
    }
}

