/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ActivationManaAbilityStep;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.ManaPool;
import mage.players.Player;

class ImproviseEffect
extends OneShotEffect {
    private final ManaCost unpaid;

    public ImproviseEffect(ManaCost unpaid) {
        super(Outcome.Benefit);
        this.unpaid = unpaid;
        this.staticText = "Improvise (Your artifacts can help cast this spell. Each artifact you tap after you're done activating mana abilities pays for {1}.)";
    }

    protected ImproviseEffect(ImproviseEffect effect) {
        super(effect);
        this.unpaid = effect.unpaid;
    }

    @Override
    public ImproviseEffect copy() {
        return new ImproviseEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Spell spell = game.getStack().getSpell(source.getSourceId());
        if (controller == null || spell == null) {
            return false;
        }
        for (UUID artifactId : this.getTargetPointer().getTargets(game, source)) {
            Permanent perm = game.getPermanent(artifactId);
            if (perm == null || perm.isTapped() || !perm.tap(source, game)) continue;
            ManaPool manaPool = controller.getManaPool();
            manaPool.addMana(Mana.ColorlessMana(1), game, source);
            manaPool.unlockManaType(ManaType.COLORLESS);
            if (!game.isSimulation()) {
                game.informPlayers("Improvise: " + controller.getLogName() + " taps " + perm.getLogName() + " to pay {1}");
            }
            spell.setCurrentActivatingManaAbilitiesStep(ActivationManaAbilityStep.AFTER);
        }
        return true;
    }
}

