/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.SpellAbility;
import mage.abilities.costs.common.DiscardTargetCost;
import mage.abilities.keyword.JumpStartReplacementEffect;
import mage.cards.Card;
import mage.constants.SpellAbilityType;
import mage.constants.Zone;
import mage.game.Game;
import mage.target.common.TargetCardInHand;
import mage.target.targetpointer.FixedTarget;

public class JumpStartAbility
extends SpellAbility {
    private boolean replacementEffectAdded = false;

    public JumpStartAbility(Card card) {
        super(card.getSpellAbility());
        this.newId();
        this.setCardName(card.getName() + " with jump-start");
        this.zone = Zone.GRAVEYARD;
        this.spellAbilityType = SpellAbilityType.BASE_ALTERNATE;
        DiscardTargetCost cost = new DiscardTargetCost(new TargetCardInHand());
        cost.setText("");
        this.addCost(cost);
    }

    protected JumpStartAbility(JumpStartAbility ability) {
        super(ability);
        this.replacementEffectAdded = ability.replacementEffectAdded;
    }

    @Override
    public SpellAbility getSpellAbilityToResolve(Game game) {
        Card card = game.getCard(this.getSourceId());
        if (card != null && !this.replacementEffectAdded) {
            this.replacementEffectAdded = true;
            JumpStartReplacementEffect effect = new JumpStartReplacementEffect();
            effect.setTargetPointer(new FixedTarget(this.getSourceId(), game.getState().getZoneChangeCounter(this.getSourceId())));
            game.addEffect(effect, this);
        }
        return this;
    }

    @Override
    public JumpStartAbility copy() {
        return new JumpStartAbility(this);
    }

    @Override
    public String getRule(boolean all) {
        return this.getRule();
    }

    @Override
    public String getRule() {
        return "Jump-start <i>(You may cast this card from your graveyard by discarding a card in addition to paying its other costs. Then exile this card.)</i>";
    }
}

