/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.StaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.keyword.MadnessCondition;
import mage.abilities.keyword.MadnessReplacementEffect;
import mage.abilities.keyword.MadnessTriggeredAbility;
import mage.constants.Zone;

public class MadnessAbility
extends StaticAbility {
    private final String rule;

    public MadnessAbility(ManaCosts<ManaCost> madnessCost) {
        this(madnessCost, 0);
    }

    public MadnessAbility(ManaCosts<ManaCost> madnessCost, int lifeCost) {
        super(Zone.HAND, new MadnessReplacementEffect(madnessCost, lifeCost));
        this.addSubAbility(new MadnessTriggeredAbility(madnessCost, lifeCost, this.getOriginalId()));
        String costText = lifeCost > 0 ? "Madness\u2014" + madnessCost.getText() + ", Pay " + lifeCost + " life." : "Madness " + madnessCost.getText();
        this.rule = costText + " <i>(If you discard this card, discard it into exile. When you do, cast it for its madness cost or put it into your graveyard.)</i>";
    }

    private MadnessAbility(MadnessAbility ability) {
        super(ability);
        this.rule = ability.rule;
    }

    @Override
    public MadnessAbility copy() {
        return new MadnessAbility(this);
    }

    public static Condition getCondition() {
        return MadnessCondition.instance;
    }

    @Override
    public String getRule() {
        return this.rule;
    }
}

