/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.Set;
import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.ActivatedAbility;
import mage.abilities.SpellAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.keyword.MayhemWatcher;
import mage.cards.Card;
import mage.constants.SpellAbilityType;
import mage.constants.Zone;
import mage.game.Game;

public class MayhemAbility
extends SpellAbility {
    public static final String MAYHEM_ACTIVATION_VALUE_KEY = "mayhemActivation";
    private final String rule;

    public MayhemAbility(Card card, String manaString) {
        super(card.getSpellAbility());
        this.newId();
        this.setCardName(card.getName() + " with Mayhem");
        this.zone = Zone.GRAVEYARD;
        this.spellAbilityType = SpellAbilityType.BASE_ALTERNATE;
        this.clearManaCosts();
        this.clearManaCostsToPay();
        this.addCost(new ManaCostsImpl(manaString));
        this.addWatcher(new MayhemWatcher());
        this.setRuleAtTheTop(true);
        this.rule = "Mayhem " + manaString + " <i>(You may cast this card from your graveyard for " + manaString + " if you discarded it this turn. Timing rules still apply.)</i>";
    }

    protected MayhemAbility(MayhemAbility ability) {
        super(ability);
        this.rule = ability.rule;
    }

    @Override
    public ActivatedAbility.ActivationStatus canActivate(UUID playerId, Game game) {
        if (!Zone.GRAVEYARD.match(game.getState().getZone(this.getSourceId())) || !MayhemWatcher.checkCard(this.getSourceId(), game)) {
            return ActivatedAbility.ActivationStatus.getFalse();
        }
        return super.canActivate(playerId, game);
    }

    @Override
    public boolean activate(Game game, Set<MageIdentifier> allowedIdentifiers, boolean noMana) {
        if (!super.activate(game, allowedIdentifiers, noMana)) {
            return false;
        }
        this.setCostsTag(MAYHEM_ACTIVATION_VALUE_KEY, null);
        return true;
    }

    @Override
    public MayhemAbility copy() {
        return new MayhemAbility(this);
    }

    @Override
    public String getRule() {
        return this.rule;
    }
}

