/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.StaticAbility;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.Costs;
import mage.abilities.costs.OptionalAdditionalCost;
import mage.abilities.costs.OptionalAdditionalCostImpl;
import mage.abilities.costs.OptionalAdditionalSourceCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.keyword.OffspringCondition;
import mage.abilities.keyword.OffspringEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

public class OffspringAbility
extends StaticAbility
implements OptionalAdditionalSourceCosts {
    private static final String keywordText = "Offspring";
    private static final String reminderText = "You may pay an additional %s as you cast this spell. If you do, when this creature enters, create a 1/1 token copy of it.";
    private final String rule;
    public static final String OFFSPRING_ACTIVATION_VALUE_KEY = "offspringActivation";
    protected OptionalAdditionalCost additionalCost;

    public OffspringAbility(String manaString) {
        this(new ManaCostsImpl(manaString));
    }

    public OffspringAbility(Cost cost) {
        super(Zone.STACK, null);
        this.additionalCost = new OptionalAdditionalCostImpl("Offspring " + cost.getText(), String.format(reminderText, cost.getText()), cost);
        this.additionalCost.setRepeatable(false);
        this.rule = this.additionalCost.getName() + ' ' + this.additionalCost.getReminderText();
        this.setRuleAtTheTop(true);
        this.addSubAbility(new EntersBattlefieldTriggeredAbility(new OffspringEffect()).withInterveningIf(OffspringCondition.instance).setRuleVisible(false));
    }

    private OffspringAbility(OffspringAbility ability) {
        super(ability);
        this.rule = ability.rule;
        this.additionalCost = ability.additionalCost.copy();
    }

    @Override
    public OffspringAbility copy() {
        return new OffspringAbility(this);
    }

    @Override
    public void addOptionalAdditionalCosts(Ability ability, Game game) {
        if (!(ability instanceof SpellAbility)) {
            return;
        }
        Player player = game.getPlayer(ability.getControllerId());
        if (player == null) {
            return;
        }
        this.additionalCost.reset();
        if (!this.additionalCost.canPay(ability, this, ability.getControllerId(), game) || !player.chooseUse(Outcome.PutCreatureInPlay, "Pay " + this.additionalCost.getText(true) + " for offspring?", ability, game)) {
            return;
        }
        this.additionalCost.activate();
        for (Cost cost : (Costs)((Object)this.additionalCost)) {
            ability.getCosts().add(cost.copy());
        }
        ability.setCostsTag(OFFSPRING_ACTIVATION_VALUE_KEY, null);
    }

    @Override
    public String getCastMessageSuffix() {
        return this.additionalCost.getCastSuffixMessage(0);
    }

    @Override
    public String getRule() {
        return this.rule;
    }
}

