/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.SpellAbility;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.constants.SpellAbilityType;
import mage.constants.TimingRule;

public class OverloadAbility
extends SpellAbility {
    public OverloadAbility(Card card, Effect effect, ManaCosts costs) {
        super(costs, card.getName() + " with overload");
        this.spellAbilityType = SpellAbilityType.BASE_ALTERNATE;
        this.addEffect(effect);
        this.timing = card.isSorcery(null) ? TimingRule.SORCERY : TimingRule.INSTANT;
    }

    protected OverloadAbility(OverloadAbility ability) {
        super(ability);
    }

    @Override
    public OverloadAbility copy() {
        return new OverloadAbility(this);
    }

    @Override
    public String getRule(boolean all) {
        return this.getRule();
    }

    @Override
    public String getRule() {
        return "Overload " + this.getManaCostsToPay().getText() + " <i>(You may cast this spell for its overload cost. If you do, change its text by replacing all instances of \"target\" with \"each.\")</i>";
    }
}

