/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class PartnersWithSearchEffect
extends OneShotEffect {
    private final String partnerName;

    public PartnersWithSearchEffect(String partnerName) {
        super(Outcome.DrawCard);
        this.partnerName = partnerName;
        this.staticText = "";
    }

    protected PartnersWithSearchEffect(PartnersWithSearchEffect effect) {
        super(effect);
        this.partnerName = effect.partnerName;
    }

    @Override
    public PartnersWithSearchEffect copy() {
        return new PartnersWithSearchEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        if (!player.chooseUse(Outcome.Benefit, "Search your library for a card named " + this.partnerName + " and put it into your hand?", source, game)) {
            return true;
        }
        FilterCard filter = new FilterCard("card named " + this.partnerName);
        filter.add(new NamePredicate(this.partnerName));
        TargetCardInLibrary target = new TargetCardInLibrary(filter);
        player.searchLibrary(target, source, game);
        CardsImpl cards = new CardsImpl((Collection<UUID>)target.getTargets());
        cards.retainZone(Zone.LIBRARY, game);
        player.revealCards(source, (Cards)cards, game);
        player.moveCards(cards, Zone.HAND, source, game);
        player.shuffleLibrary(source, game);
        return true;
    }
}

