/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.List;
import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.PlotSpellAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class PlotAddSpellAbilityEffect
extends ContinuousEffectImpl {
    private final MageObjectReference mor;

    PlotAddSpellAbilityEffect(MageObjectReference mor) {
        super(Duration.EndOfGame, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.mor = mor;
        this.staticText = "Plot card";
    }

    private PlotAddSpellAbilityEffect(PlotAddSpellAbilityEffect effect) {
        super(effect);
        this.mor = effect.mor;
    }

    @Override
    public PlotAddSpellAbilityEffect copy() {
        return new PlotAddSpellAbilityEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Card card = this.mor.getCard(game);
        if (card == null) {
            this.discard();
            return true;
        }
        Card mainCard = card.getMainCard();
        UUID mainCardId = mainCard.getId();
        Player player = game.getPlayer(card.getOwnerId());
        if (game.getState().getZone(mainCardId) != Zone.EXILED || player == null) {
            this.discard();
            return true;
        }
        List<Card> faces = CardUtil.getCastableComponents(mainCard, null, source, player, game, null, false);
        for (Card face : faces) {
            PlotSpellAbility ability = new PlotSpellAbility(face.getName());
            ability.setSourceId(face.getId());
            ability.setControllerId(player.getId());
            ability.setSpellAbilityType(face.getSpellAbility().getSpellAbilityType());
            game.getState().addOtherAbility(face, ability);
        }
        return true;
    }
}

