/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.constants.GiftType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetOpponent;

class PromiseGiftCost
extends CostImpl {
    PromiseGiftCost(GiftType giftType) {
        this.text = "Gift " + giftType.getName();
    }

    private PromiseGiftCost(PromiseGiftCost cost) {
        super(cost);
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return true;
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player player = game.getPlayer(controllerId);
        if (player == null) {
            return this.paid;
        }
        TargetOpponent target = new TargetOpponent();
        target.withNotTarget(true);
        player.choose(Outcome.Detriment, target, source, game);
        Player opponent = game.getPlayer(target.getFirstTarget());
        if (opponent == null) {
            return this.paid;
        }
        source.setCostsTag("giftPromisedActivation", opponent.getId());
        this.paid = true;
        return this.paid;
    }

    @Override
    public PromiseGiftCost copy() {
        return new PromiseGiftCost(this);
    }
}

