/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.condition.common.ProwlCondition;
import mage.abilities.costs.AlternativeSourceCostsImpl;
import mage.abilities.hint.common.ProwlHint;
import mage.game.Game;
import mage.watchers.common.ProwlWatcher;

public class ProwlAbility
extends AlternativeSourceCostsImpl {
    private static final String PROWL_KEYWORD = "Prowl";
    private static final String PROWL_REMINDER = "You may cast this for its prowl cost if you dealt combat damage to a player this turn with a creature that shared a creature type with {this}";

    public ProwlAbility(String manaString) {
        super(PROWL_KEYWORD, PROWL_REMINDER, manaString);
        this.setRuleAtTheTop(true);
        this.addWatcher(new ProwlWatcher());
        this.addHint(ProwlHint.instance);
    }

    private ProwlAbility(ProwlAbility ability) {
        super(ability);
    }

    @Override
    public ProwlAbility copy() {
        return new ProwlAbility(this);
    }

    @Override
    public boolean isAvailable(Ability source, Game game) {
        return ProwlCondition.instance.apply(game, source);
    }

    public static String getActivationKey() {
        return ProwlAbility.getActivationKey(PROWL_KEYWORD);
    }
}

