/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ReconfigureTypeEffect
extends ContinuousEffectImpl {
    ReconfigureTypeEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
    }

    private ReconfigureTypeEffect(ReconfigureTypeEffect effect) {
        super(effect);
    }

    @Override
    public ReconfigureTypeEffect copy() {
        return new ReconfigureTypeEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || game.getPermanent(permanent.getAttachedTo()) == null) {
            return false;
        }
        permanent.removeCardType(game, CardType.CREATURE);
        permanent.removeAllCreatureTypes(game);
        return true;
    }
}

