/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.ActivatedAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.keyword.ReconfigureUnattachEffect;
import mage.constants.TimingRule;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ReconfigureUnattachAbility
extends ActivatedAbilityImpl {
    protected ReconfigureUnattachAbility(Cost cost) {
        super(Zone.BATTLEFIELD, new ReconfigureUnattachEffect(), cost);
        this.condition = ReconfigureUnattachAbility::checkForCreature;
        this.timing = TimingRule.SORCERY;
        this.setRuleVisible(false);
    }

    private ReconfigureUnattachAbility(ReconfigureUnattachAbility ability) {
        super(ability);
    }

    @Override
    public ReconfigureUnattachAbility copy() {
        return new ReconfigureUnattachAbility(this);
    }

    @Override
    public String getRule() {
        return super.getRule() + " Activate only if this permanent is attached to a creature and only as a sorcery.";
    }

    private static boolean checkForCreature(Game game, Ability source) {
        Permanent equipment = source.getSourcePermanentIfItStillExists(game);
        if (equipment == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(equipment.getAttachedTo());
        return permanent != null && permanent.isCreature(game);
    }
}

