/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.keyword.RepairedCastFromGraveyardEffect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;

class RepairCastFromGraveyardTriggeredAbility
extends TriggeredAbilityImpl {
    RepairCastFromGraveyardTriggeredAbility() {
        super(Zone.GRAVEYARD, new RepairedCastFromGraveyardEffect());
        this.setRuleVisible(false);
    }

    private RepairCastFromGraveyardTriggeredAbility(RepairCastFromGraveyardTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTER_REMOVED;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getTargetId().equals(this.getSourceId())) {
            Card card = game.getCard(this.getSourceId());
            return card != null && game.getState().getZone(card.getId()) == Zone.GRAVEYARD && event.getData().equals(CounterType.REPAIR.getName()) && card.getCounters(game).getCount(CounterType.REPAIR) == 0;
        }
        return false;
    }

    @Override
    public String getRule() {
        return "Whenever the last repair counter is removed, you may cast {this} from your graveyard until end of turn";
    }

    @Override
    public RepairCastFromGraveyardTriggeredAbility copy() {
        return new RepairCastFromGraveyardTriggeredAbility(this);
    }
}

