/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;

class RepairedCastFromGraveyardEffect
extends OneShotEffect {
    RepairedCastFromGraveyardEffect() {
        super(Outcome.Benefit);
    }

    private RepairedCastFromGraveyardEffect(RepairedCastFromGraveyardEffect effect) {
        super(effect);
    }

    @Override
    public RepairedCastFromGraveyardEffect copy() {
        return new RepairedCastFromGraveyardEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = source.getSourceCardIfItStillExists(game);
        if (controller == null || card == null) {
            return false;
        }
        game.addEffect(new PlayFromNotOwnHandZoneTargetEffect(Zone.GRAVEYARD, Duration.UntilYourNextEndStep).setTargetPointer(new FixedTarget(card, game)), source);
        return true;
    }
}

