/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.ReplicateAbility;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class ReplicateCopyEffect
extends OneShotEffect {
    public ReplicateCopyEffect() {
        super(Outcome.Copy);
    }

    protected ReplicateCopyEffect(ReplicateCopyEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Spell spell = (Spell)this.getValue("ReplicateSpell");
        int replicateCount = (Integer)this.getValue("ReplicateCount");
        if (controller == null || spell == null || replicateCount == 0) {
            return false;
        }
        Card card = game.getCard(spell.getSourceId());
        if (card == null) {
            return false;
        }
        for (Ability ability : card.getAbilities(game)) {
            if (!(ability instanceof ReplicateAbility) || !ability.isActivated()) continue;
            ((ReplicateAbility)ability).resetReplicate();
        }
        spell.createCopyOnStack(game, source, source.getControllerId(), true, replicateCount);
        return true;
    }

    @Override
    public ReplicateCopyEffect copy() {
        return new ReplicateCopyEffect(this);
    }
}

