/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SkulkEffect
extends RestrictionEffect {
    public SkulkEffect(Duration duration) {
        super(duration);
        this.staticText = "Skulk <i>(This creature can't be blocked by creatures with greater power.)</i>";
    }

    protected SkulkEffect(SkulkEffect effect) {
        super(effect);
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(source.getSourceId());
    }

    @Override
    public boolean canBeBlocked(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return blocker.getPower().getValue() <= attacker.getPower().getValue();
    }

    @Override
    public SkulkEffect copy() {
        return new SkulkEffect(this);
    }
}

