/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.keyword.SoulbondEntersOtherAbility;
import mage.abilities.keyword.SoulboundEntersSelfEffect;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class SoulbondAbility
extends EntersBattlefieldTriggeredAbility {
    public SoulbondAbility() {
        super(new SoulboundEntersSelfEffect(), true);
        this.addSubAbility(new SoulbondEntersOtherAbility());
    }

    public SoulbondAbility(SoulbondAbility ability) {
        super(ability);
    }

    @Override
    public String getRule() {
        return "Soulbond <i>(You may pair this creature with another unpaired creature when either enters the battlefield. They remain paired for as long as you control both of them.)</i>";
    }

    @Override
    public boolean checkInterveningIfClause(Game game) {
        boolean self = false;
        boolean other = false;
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents(this.getControllerId())) {
            if (!permanent.isCreature(game)) continue;
            if (permanent.getId().equals(this.getSourceId())) {
                if (permanent.isControlledBy(this.getControllerId())) {
                    self = true;
                    if (!other) continue;
                    return true;
                }
                return false;
            }
            if (permanent.getPairedCard() != null) continue;
            other = true;
            if (!self) continue;
            return true;
        }
        return false;
    }

    @Override
    public SoulbondAbility copy() {
        return new SoulbondAbility(this);
    }
}

