/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.SpliceCardEffect;
import mage.abilities.keyword.SpliceAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.EffectType;
import mage.constants.Outcome;
import mage.constants.SpellAbilityType;
import mage.filter.FilterObject;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class SpliceCardEffectImpl
extends ContinuousEffectImpl
implements SpliceCardEffect {
    private final FilterObject filter;

    public SpliceCardEffectImpl(FilterObject filter) {
        super(Duration.WhileOnBattlefield, Outcome.Copy);
        this.effectType = EffectType.SPLICE;
        this.filter = filter;
        this.staticText = "Splice onto " + filter;
    }

    private SpliceCardEffectImpl(SpliceCardEffectImpl effect) {
        super(effect);
        this.filter = effect.filter;
    }

    @Override
    public SpliceCardEffectImpl copy() {
        return new SpliceCardEffectImpl(this);
    }

    @Override
    public final boolean apply(Game game, Ability source) {
        return false;
    }

    @Override
    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        Player controller = game.getPlayer(source.getControllerId());
        Card spliceCard = game.getCard(source.getSourceId());
        if (spliceCard != null && controller != null) {
            Spell spell = game.getStack().getSpell(abilityToModify.getId());
            if (spell != null) {
                SpellAbility splicedAbility = spliceCard.getSpellAbility().copy();
                splicedAbility.setSpellAbilityType(SpellAbilityType.SPLICE);
                splicedAbility.setSourceId(abilityToModify.getSourceId());
                spell.addSpellAbility(splicedAbility);
                for (Cost cost : ((SpliceAbility)source).getSpliceCosts()) {
                    if (cost instanceof ManaCost) {
                        spell.getSpellAbility().addManaCostsToPay((ManaCost)cost.copy());
                        continue;
                    }
                    spell.getSpellAbility().addCost(cost.copy());
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (!this.filter.match(game.getObject(abilityToModify.getSourceId()), game)) {
            return false;
        }
        Card card = game.getCard(source.getSourceId());
        if (card == null) {
            return false;
        }
        return card.getSpellAbility().canSpliceOnto(abilityToModify, game);
    }
}

