/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class StationLevelAbilityEffect
extends ContinuousEffectImpl {
    private final Ability ability;
    private final int level;

    StationLevelAbilityEffect(Ability ability, int level) {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.ability = ability;
        this.level = level;
        this.ability.setRuleVisible(false);
        this.staticText = ability.getRule();
    }

    private StationLevelAbilityEffect(StationLevelAbilityEffect effect) {
        super(effect);
        this.ability = effect.ability;
        this.level = effect.level;
    }

    @Override
    public StationLevelAbilityEffect copy() {
        return new StationLevelAbilityEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || permanent.getCounters(game).getCount(CounterType.CHARGE) < this.level) {
            return false;
        }
        permanent.addAbility(this.ability, source.getSourceId(), game);
        return true;
    }
}

