/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class StationLevelCreatureEffect
extends ContinuousEffectImpl {
    private final int power;
    private final int toughness;
    private final int level;

    StationLevelCreatureEffect(int power, int toughness, int level) {
        super(Duration.WhileOnBattlefield, Outcome.BecomeCreature);
        this.power = power;
        this.toughness = toughness;
        this.level = level;
        this.staticText = power + "/" + toughness;
    }

    private StationLevelCreatureEffect(StationLevelCreatureEffect effect) {
        super(effect);
        this.power = effect.power;
        this.toughness = effect.toughness;
        this.level = effect.level;
    }

    @Override
    public StationLevelCreatureEffect copy() {
        return new StationLevelCreatureEffect(this);
    }

    @Override
    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || permanent.getCounters(game).getCount(CounterType.CHARGE) < this.level) {
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.addCardType(game, CardType.CREATURE);
                return true;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) {
                    return false;
                }
                permanent.getPower().setModifiedBaseValue(this.power);
                permanent.getToughness().setModifiedBaseValue(this.toughness);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return false;
    }

    @Override
    public boolean hasLayer(Layer layer) {
        switch (layer) {
            case TypeChangingEffects_4: 
            case PTChangingEffects_7: {
                return true;
            }
        }
        return false;
    }
}

