/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.MageObjectReference;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.abilities.keyword.SpellsCastThisTurnValue;
import mage.abilities.keyword.StormEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;

public class StormAbility
extends TriggeredAbilityImpl {
    private static final Hint hint = new ValueHint("Spells cast this turn", SpellsCastThisTurnValue.instance);

    public static Hint getHint() {
        return hint;
    }

    public StormAbility() {
        super(Zone.STACK, new StormEffect());
        this.addHint(hint);
    }

    private StormAbility(StormAbility ability) {
        super(ability);
    }

    @Override
    public StormAbility copy() {
        return new StormAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        StackObject spell;
        if (event.getSourceId().equals(this.getSourceId()) && (spell = game.getStack().getStackObject(this.getSourceId())) instanceof Spell) {
            for (Effect effect : this.getEffects()) {
                effect.setValue("StormSpell", spell);
                effect.setValue("StormSpellRef", new MageObjectReference(spell.getId(), game));
            }
            return true;
        }
        return false;
    }

    @Override
    public String getRule() {
        return "Storm <i>(When you cast this spell, copy it for each spell cast before it this turn. You may choose new targets for the copies.)</i>";
    }
}

