/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.keyword.SuspendPlayCardEffect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;

class SuspendPlayCardAbility
extends TriggeredAbilityImpl {
    SuspendPlayCardAbility() {
        super(Zone.EXILED, new SuspendPlayCardEffect());
        this.setRuleVisible(false);
    }

    private SuspendPlayCardAbility(SuspendPlayCardAbility ability) {
        super(ability);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTER_REMOVED;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getTargetId().equals(this.getSourceId())) {
            Card card = game.getCard(this.getSourceId());
            return card != null && game.getState().getZone(card.getId()) == Zone.EXILED && card.getCounters(game).getCount(CounterType.TIME) == 0;
        }
        return false;
    }

    @Override
    public String getRule() {
        return "When the last time counter is removed from {this}, if it's exiled, ";
    }

    @Override
    public SuspendPlayCardAbility copy() {
        return new SuspendPlayCardAbility(this);
    }
}

