/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.Objects;
import mage.MageInt;
import mage.MageObject;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

public class TrainingAbility
extends TriggeredAbilityImpl {
    public TrainingAbility() {
        super(Zone.BATTLEFIELD, new AddCountersSourceEffect(CounterType.P1P1.createInstance()));
    }

    private TrainingAbility(TrainingAbility ability) {
        super(ability);
    }

    @Override
    public TrainingAbility copy() {
        return new TrainingAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (!game.getCombat().getAttackers().contains(this.getSourceId())) {
            return false;
        }
        Permanent permanent = this.getSourcePermanentIfItStillExists(game);
        if (permanent == null) return false;
        if (!game.getCombat().getAttackers().stream().map(game::getPermanent).filter(Objects::nonNull).map(MageObject::getPower).mapToInt(MageInt::getValue).anyMatch(x -> x > permanent.getPower().getValue())) return false;
        return true;
    }

    @Override
    public String getRule() {
        return "Training <i>(Whenever this creature attacks with another creature with greater power, put a +1/+1 counter on this creature.)</i>";
    }
}

